<?php defined('BASEPATH') OR exit('No direct script access allowed');

/**
* Parent controller for all areas limited to logged-in users.  
*
* Checks to make sure that we have the user set up in the session, and sets a class var for the user so that we don't have to keep hitting up the database
* every time we need the username or other db info.  Having only one place where this code is written will ensure that it's consistent and make it easier to
* make any necessary changes.
*
* @package direct-as-a-service
* @subpackage controllers
* @filesource
*/ /** */

require_once APPPATH.'models/mailbox.php';
require_once APPPATH.'models/user.php';

/**
* @package direct-as-a-service
* @subpackage controllers
*/ 
class Admin_controller extends CI_Controller {
	
	var $user; //a User object represent the currently logged-in user
	var $show;
	var $account_permissions;
	public function __construct(){
		parent::__construct();
		$this->load->library(array('session','encrypt','eventlog','permissions','auth','locale'));
		$this->load->model(array('applicationmodel','facilitymodel', 'usersmodel', 'usersettingsmodel'));
		$this->load->helper('url'); 
		
		get_instance()->load->library('Error_helper', array(), 'error');
		get_instance()->load->library('Validator', array(), 'is');	
		
		date_default_timezone_set(ENVIRONMENT_TIMEZONE);

		//check if the user is authorized
		$login_status = $this->session->userdata('is_loggedin');
		if(!isset($login_status) || $login_status !== 'true') {
			//if the user has authenticated via PIV, the controller will load 
			//if not then a 401 Unauthorized error will be shown
			if(!$this->auth->perform_auth()) { show_error('Unauthorized',401); }
		}	
		//check if user has agreed to banner
		$banner = $this->session->userdata('banner_agree');
		if ((!isset($banner) || $banner !== 'true' ) 
				&& 'onboarding/banner' !== uri_string() 
				&& 'onboarding/banner_agree' !== uri_string()) {

			$this->session->set_flashdata('redirect_uri',uri_string());
			redirect('onboarding/banner');
		} 
		
		//find the user in our db and make sure a user object is available to the entire controller, so that people don't have to keep doing db lookups to get id/username, etc
		$this->user = User::find_from_session();
		if(!User::is_an_entity($this->user) || !$this->user->active){
			redirect('onboarding');
		}
		$this->account_permissions = $this->user->permissions;
		$this->show = $this->permissions->set_tab_access_from_permissions($this->account_permissions);
		$this->verify_access(get_called_class());
	}
	protected function has_access($access){
		if($this->user->is_admin()){
			return true;
		}
		else{
			return in_array(mb_strtolower($access), $this->account_permissions["Permission"]);
		}
	}
	protected function verify_access($access){
		if($this->user->is_admin()){
			return;
		}
		else{
			$access = mb_strtolower($access);
			if(!(in_array($access, $this->account_permissions["Permission"])||(isset($this->show[$access])&&$this->show[$access]))){
				//redirect('onboarding');
				show_404();
			}
		}
	}

}